'use strict'

entityRegistry['module']['edgeDetect'] = {
    extendedInfo: {
        displayName: 'Edge Detect',
        displayGroup: 'Post Processing',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'edgeBrightness', displayName: 'Edge Brightness', type: 'float', defaultValue: 0.5},
        { paramName: 'fixupEdges', displayName: 'Fixup Edges', type: 'boolean', defaultValue: true},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                edgeBrightness,
                fixupEdges,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const t = currentFrameTime
            const edgeFixups = []
            for (let y = 1; y < colorBuffer.height-1; ++y) {
                let i = colorBuffer.width * y + 1
                for (let x = 1; x < colorBuffer.width-1; ++x) {
                    const target = colorBuffer.data[i]
                    if (colorBuffer.data[i-1] !== target ||
                        colorBuffer.data[i+1] !== target ||
                        colorBuffer.data[i-colorBuffer.width] !== target ||
                        colorBuffer.data[i+colorBuffer.width] !== target) {
                        brightnessBuffer.data[i] = edgeBrightness
                        if (target === 0) {
                            edgeFixups.push(i)
                        }
                    } else {
                        // brightnessBuffer.data[i] *= 1
                    }
                    ++i
                }
            }
            if (fixupEdges) {
                edgeFixups.forEach(i => colorBuffer.data[i] = 1)
            }
        }
    }
}
